Town = -1
TownPeople = []
PeopleTypes = []

function GrabTownMap()
{
	TownMap = []

	layer = GetPersonLayer(People[Player].name)
	
	w = GetLayerWidth(layer)
	h = GetLayerHeight(layer)
	
	for (var x = 0; x < w; x++)
	 {
		 TownMap.push([])
	   for (var y = 0; y < h; y++)
			 {
				 TownMap[x][y] = GetTile(x,y,layer)
			 }
	 }
	
	return TownMap
	  
}

function MakeTownMap(TownMap)
{
	layer = GetPersonLayer(People[Player].name)
	
	w = GetLayerWidth(layer)
	h = GetLayerHeight(layer)
	
	for (var x = 0; x < w; x++)
	 {
	   for (var y = 0; y < h; y++)
			 {
					SetTile(x,y,layer,TownMap[x][y])
			 }
	 }
}

function GrabTownPeople()
{
	TownPersons = []
	for (var i = 1; i < People.length; i++)
		{
			if (People[i].type != -1)
				{
					TownPersons.push(new TownPerson(
																					People[i].name,
																					GetPersonX(People[i].name),
																					GetPersonY(People[i].name),
																					People[i].inventory,
																					People[i].type
																				 ))
				}
		}
	//Abort(TownPersons)
	return TownPersons

}

function GenerateTownPeople()
{
	for (var i = 0; i < TownPeople.length; i++)
		{
			Type = PeopleTypes[TownPeople[i].type]
			Me = TownPeople[i]
			People.push( new Person(Me.name,Type.Sprite,Type.Touch,Type.Hurt,Type.Update,Me.x,Me.y,true) )
			People[People.length-1].inventory = Me.inventory
			People[People.length-1].type = Me.type
		}
}

function PersonType(Sprite,Touch,Hurt,Update)
{
	this.Sprite = Sprite
	this.Touch = Touch
	this.Hurt = Hurt
	this.Update = Update
}

function TownPerson(name,x,y,inventory,type)
{
	this.name = name
	this.x = x
	this.y = y
	this.inventory = inventory
	this.type = type
}

PeopleTypes.push(new PersonType( //0
																"NPC-Oliver.rss",
																eNPCTouch,eNPCHurt,ePaceUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //1
																"NPC-Elder.rss",
																eNPCTouch,eNPCHurt,eBobUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //2
																"NPC-Sonja.rss",
																eNPCTouch,eNPCHurt,ePaceUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //3
																"NPC-Wolfgang.rss",
																eNPCTouch,eNPCHurt,ePaceUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //4
																"NPC-Bob.rss",
																eNPCTouch,eNPCHurt,eBobUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //5
																"NPC-Nathaniel.rss",
																eNPCTouch,eNPCHurt,eNPCUpdate
															 ))
															 
PeopleTypes.push(new PersonType( //6
																"bed.rss",
																eBedTouch,eNPCHurt,eNPCUpdate
															 ))															 							
															 
TownPeople.push(new TownPerson("Oliver",114,131,[0,0],0)) //Oliver	
TownPeople.push(new TownPerson("Sonja",244,328,[],2)) //Sonja	
TownPeople.push(new TownPerson("Elder",323,244,[],1)) //Elder
TownPeople.push(new TownPerson("Bob",468,386,[],4)) //Bob
TownPeople.push(new TownPerson("Nathaniel",593,176,[],5)) //Nathaniel		
TownPeople.push(new TownPerson("Wolfgang",258,504,[],3)) //Wolfgang

function SaveGame(filename)
{
	TownPeople = new Array()
	TownPeople = GrabTownPeople()
	Town = GrabTownMap()
	
	f = OpenFile(filename)

	for (var x = 0; x < Town.length; x++)
	 {
	   for (var y = 0; y < Town[0].length; y++)
			 {
					f.write("TOWNMAP-"+x+"-"+y,TownMap[x][y])
			 }
	 }
	 
	f.write("TOWNMAPX",Town.length) 
	f.write("TOWNMAPY",Town[0].length) 
	 
	for (var i = 0; i < TownPeople.length; i++)
		{
			f.write("TOWNPEOPLE-NAME-"+i,TownPeople[i].name)
			f.write("TOWNPEOPLE-X-"+i,TownPeople[i].x)
			f.write("TOWNPEOPLE-Y-"+i,TownPeople[i].y)
			f.write("TOWNPEOPLE-TYPE-"+i,TownPeople[i].type)
			for (var i2 = 0; i2 < TownPeople[i].inventory.length; i2++)
				{
					f.write("TOWNPEOPLE-INV-"+i+"-"+i2,TownPeople[i].inventory[i2])
				}
			f.write("TOWNPEOPLE-INV_SIZE-"+i,TownPeople[i].inventory.length)	
		}
		
	f.write("TOWNPEOPLE-SIZE",TownPeople.length)
		
	f.write("PLAYER-NAME",People[Player].name)
	f.write("PLAYER-SPRITE",People[Player].sprite)
	
	f.write("PLAYER-STR",People[Player].str)
	f.write("PLAYER-DEX",People[Player].dex)
	f.write("PLAYER-LCK",People[Player].lck)
	
	f.write("PLAYER-WEAPON-STR",People[Player].weapon_bonus_str)
	f.write("PLAYER-WEAPON-DEX",People[Player].weapon_bonus_dex)
	f.write("PLAYER-WEAPON-LCK",People[Player].weapon_bonus_lck)
	
	f.write("PLAYER-WEAPON-NUMBER",People[Player].weapon_number)
	f.write("PLAYER-WEAPON-ANIM",People[Player].weapon_anim)
	f.write("PLAYER-WEAPON",People[Player].weapon)
	
	f.write("PLAYER-XP",People[Player].xp)
	f.write("PLAYER-GOLD",People[Player].gold)
	
	f.write("PLAYER-HP",People[Player].hp)
	
	f.write("PLAYER-X", GetPersonX(People[Player].name) )
	f.write("PLAYER-Y", GetPersonY(People[Player].name) )

	for (var i = 0; i < People[Player].inventory.length; i++)
		{
			f.write("PLAYER-INV-"+i,People[Player].inventory[i])
		}
		
	f.write("PLAYER-INV_SIZE",People[Player].inventory.length)
	
	f.write("DAY",Day)
	
	f.write("TRIPS",Trips)
	
	for (var i = 0; i < Flag.length; i++)
		{
			f.write("FLAG-"+i,Flag[i])
		}			
	
	f.write("FLAG-LENGTH-",Flag.length)	
	
	f.flush()
	
}	

function LoadGame(filename)
{

	NewGame(false)

	f = OpenFile(filename)

	w = f.read("TOWNMAPX", 0)
	h = f.read("TOWNMAPY", 0)

	Town = new Array()

	for (var x = 0; x < w; x++)
	 {
		 Town.push(new Array())
	   for (var y = 0; y < h; y++)
			 {
					Town[x][y] = f.read("TOWNMAP-"+x+"-"+y, 0)
			 }
	 }
	 
	//Abort(TownMap) 
	 
	size = f.read("TOWNPEOPLE-SIZE", 0)
	
	TownPeople = new Array() 
	for (var i = 0; i < size; i++)
		{
			TownPeople.push(new TownPerson())
			TownPeople[i].name = f.read("TOWNPEOPLE-NAME-"+i,"")
			TownPeople[i].x = f.read("TOWNPEOPLE-X-"+i,0)
			TownPeople[i].y = f.read("TOWNPEOPLE-Y-"+i,0)
			TownPeople[i].type = f.read("TOWNPEOPLE-TYPE-"+i,0)
			inv_size = f.read("TOWNPEOPLE-INV_SIZE-"+i, 0)
			TownPeople[i].inventory = new Array()
			for (var i2 = 0; i2 < inv_size; i2++)
				{
					TownPeople[i].inventory[i2] = f.read("TOWNPEOPLE-INV-"+i+"-"+i2,0)
				}
		}
		
		
	People[Player].name = f.read("PLAYER-NAME", "hero")
	People[Player].sprite = f.read("PLAYER-SPRITE", "hero.rss")
	
	People[Player].str = f.read("PLAYER-STR", 3)
	People[Player].dex = f.read("PLAYER-DEX", 3)
	People[Player].lck = f.read("PLAYER-LCK", 3)

	People[Player].weapon_bonus_str = f.read("PLAYER-WEAPON-STR",0)
	People[Player].weapon_bonus_dex = f.read("PLAYER-WEAPON-DEX",0)
	People[Player].weapon_bonus_lck = f.read("PLAYER-WEAPON-LCK",0)
	
	People[Player].weapon_number = f.read("PLAYER-WEAPON-NUMBER",0)
	People[Player].weapon_anim = f.read("PLAYER-WEAPON-ANIM",0)
	People[Player].weapon = f.read("PLAYER-WEAPON","hero.rss")	
	
	People[Player].xp = f.read("PLAYER-XP", 0)
	People[Player].gold = f.read("PLAYER-GOLD", 0)	
	
	People[Player].hp = f.read("PLAYER-HP", 3)		

	inv_size = f.read("PLAYER-INV_SIZE",0)

	People[Player].inventory = new Array()

	for (var i = 0; i < inv_size; i++)
		{
			People[Player].inventory[i] = f.read("PLAYER-INV-"+i,0)
		}
	
	loaded = true

	lx = f.read("PLAYER-X", 0) 
	ly = f.read("PLAYER-Y", 0) 
	
	Day = f.read("DAY",0)
	
	Trips = f.read("TRIPS",0)	
	
	fnum = f.read("FLAG-LENGTH-",0)	
	
	for (var i = 0; i < fnum; i++)
		{
			Flag[i] = f.read("FLAG-"+i,0)
		}			
	
	
	
	f.close();
	
	MapEngine("town.rmp", 60);
	
}							

function GetGameStats(filename)
{
	f = OpenFile(filename)
	
	Days = f.read("DAY",-200)
	
	str = f.read("PLAYER-STR", 3)
	dex = f.read("PLAYER-DEX", 3)
	lck = f.read("PLAYER-LCK", 3)
	
	f.close()
	
	return [Days,str,dex,lck]
}					 								 															 															 															 															 